#!/bin/bash

##
## This script is the preferred way to start ice-remoteware.  Arguments
## passed to this script are passed directly to the server.
##

# Handle arguments.
ARGS="${@:1}"

# find out where this script is stored
SOURCE="${BASH_SOURCE[0]}"
while [ -h "$SOURCE" ]; do # resolve $SOURCE until the file is no longer a symlink
    DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
    SOURCE="$(readlink "$SOURCE")"
    [[ $SOURCE != /* ]] && SOURCE="$DIR/$SOURCE" # if $SOURCE was a relative symlink, we need to resolve it relative to the path where the symlink file was located
done
BASH_DIR="$( cd -P "$( dirname "$SOURCE" )" && pwd )"

function clean_exit() {
    popd &> /dev/null
    exit $1
}

##
## Start ice-remoteware
##
pushd $BASH_DIR &> /dev/null

./ice-remoteware $ARGS
STATUS=$?

clean_exit $STATUS
